/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.data.tcon;

import java.util.Locale;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.smeltery.data.Byproduct;
import tcintegrations.items.TCIntegrationsItems;

public enum SmelteryCompat {
    MANASTEEL(TCIntegrationsItems.MOLTEN_MANASTEEL, "botania", Byproduct.IRON, Byproduct.GOLD),
    NEPTUNIUM(TCIntegrationsItems.MOLTEN_NEPTUNIUM, "aquaculture", new Byproduct[0]),
    SOUL_STAINED_STEEL(TCIntegrationsItems.MOLTEN_SOUL_STAINED_STEEL, "malum", new Byproduct[0]),
    CLOGGRUM(TCIntegrationsItems.MOLTEN_CLOGGRUM, "undergarden", new Byproduct[0]),
    FROSTSTEEL(TCIntegrationsItems.MOLTEN_FROSTSTEEL, "undergarden", new Byproduct[0]),
    FORGOTTEN(TCIntegrationsItems.MOLTEN_FORGOTTEN, "undergarden", new Byproduct[0]),
    PENDORITE_ALLOY(TCIntegrationsItems.MOLTEN_PENDORITE_ALLOY, "byg", new Byproduct[0]);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final boolean isOre;
    private final boolean hasDust;
    private final Byproduct[] byproducts;
    private final String modid;

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String modid, boolean hasDust) {
        this.fluid = fluid;
        this.isOre = false;
        this.byproducts = new Byproduct[0];
        this.hasDust = hasDust;
        this.modid = modid;
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String modid, Byproduct ... byproducts) {
        this.fluid = fluid;
        this.isOre = byproducts.length > 0;
        this.byproducts = byproducts;
        this.hasDust = true;
        this.modid = modid;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public Item getBucket() {
        return this.fluid.m_5456_();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public boolean hasDust() {
        return this.hasDust;
    }

    public Byproduct[] getByproducts() {
        return this.byproducts;
    }

    public String getModid() {
        return this.modid;
    }
}

